/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Text.RegularExpressions;
using LFSLapper;


namespace lexCfg
{
    enum tokenExpr
    {
        notfound,
        and,
        or,
        equal,
        diff,
        moreThan,
        lessThan,
        moreThanEqual,
        lessThanEqual,
        concat,
        plus,
        minus,
        mult,
        div,
        pow,
        nbVal,
    }
    class unionVal
    {
        public float fval;
        public string sval;
        public char typVal;
        public unionVal( float pfval,string psval,char ptypval ){
            this.fval = pfval;
            this.sval = psval;
            this.typVal = ptypval;
        }
    }
    class Parseur
    {
        public Parseur expra;
        public Parseur exprb;
        public tokenExpr operateur;
        public unionVal val = new unionVal( 0,"",'I' );

        public Parseur(string str)
        {


            this.expra = null;
            this.exprb = null;
            this.operateur = tokenExpr.notfound;

            str = str.Trim();
            if (str == "")
            {
                this.val.sval = "\"\"";
                this.val.typVal = 'S';
            }
            else if (this.isString( str ))
            {
                this.val.sval = str;
                this.val.typVal = 'S';
            }
            else if (this.isNumeric(str))
            {
                this.val.fval = this.numval(str);
                this.val.typVal = 'N';
            }
            else
            {
                this.val.typVal = 'I';
                int p = 0;
                int cp0 = 0;
                int l = str.Length;
                //on recupere la liste des operateurs
                bool[] operateurs = new bool[(int)tokenExpr.nbVal];

                for (int i = 0; i < (int)tokenExpr.nbVal; i++)
                    operateurs[i] = true;

                //on recupere la liste des operateurs
                bool inStr = false;
                for (int i = 0; i < l; i++)
                {
                    if( inStr && str[i] == '\\' ){
                        i++;
                        continue;
                    }
                    if (str[i] == '"')
                    {
                        if (inStr)
                            inStr = false;
                        else
                            inStr = true;
                    }
                    if (inStr)
                        continue;
                    if (str[i] == '(')
                    {
                        p++;
                    }
                    else if (str[i] == ')')
                        p--;
                    else if (p == 0)
                    {
                        tokenExpr token = tokenExpr.notfound;
                        if (str[i] == '&' && i < (l - 1) && str[i + 1] == '&')
                        {
                            token = tokenExpr.and;
                            i++;
                        }
                        else if (str[i] == '|' && i < (l - 1) && str[i + 1] == '|')
                        {
                            token = tokenExpr.or;
                            i++;
                        }
                        else if (str[i] == '=' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.equal;
                            i++;
                        }
                        else if (str[i] == '!' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.diff;
                            i++;
                        }
                        else if (str[i] == '>' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.moreThanEqual;
                            i++;
                        }
                        else if (str[i] == '<' && i < (l - 1) && str[i + 1] == '=')
                        {
                            token = tokenExpr.lessThanEqual;
                            i++;
                        }
                        else if (str[i] == '>')
                            token = tokenExpr.moreThan;
                        else if (str[i] == '<')
                            token = tokenExpr.lessThan;
                        else if (str[i] == '.')
                            token = tokenExpr.concat;
                        else if (str[i] == '+')
                            token = tokenExpr.plus;
                        else if (str[i] == '-')
                            token = tokenExpr.minus;
                        else if (str[i] == '*')
                            token = tokenExpr.mult;
                        else if (str[i] == '/')
                            token = tokenExpr.div;
                        else if (str[i] == '^')
                            token = tokenExpr.pow;
                        if (token != tokenExpr.notfound)
                        {
                            for (int j = (int)token + 1; j < (int)tokenExpr.nbVal; j++)
                                operateurs[j] = false;
                        }
                    }
                }
                if (p != 0)
                {
                    throw new Exception("Nombre de parentheses incorrect");
                }
                inStr = false;
                for (int i = l - 1; i >= 0; i--)
                {
                    if (inStr && str[i] == '"' && i > 0 && str[i-1] == '\\')
                    {
                        i--;
                        continue;
                    }
                    if (str[i] == '"')
                    {
                        if (inStr)
                            inStr = false;
                        else
                            inStr = true;
                    }
                    if (inStr)
                        continue;

                    if (p == 0)
                    {
                        cp0++;
                    }
                    tokenExpr token = tokenExpr.notfound;
                    int firstPart = i;
                    int secondPart = i;
                    if (str[i] == '&' && i > 0 && str[i - 1] == '&')
                    {
                        token = tokenExpr.and;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '|' && i > 0 && str[i - 1] == '|')
                    {
                        token = tokenExpr.or;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '=')
                    {
                        token = tokenExpr.equal;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '!')
                    {
                        token = tokenExpr.diff;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '>')
                    {
                        token = tokenExpr.moreThanEqual;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '=' && i > 0 && str[i - 1] == '<')
                    {
                        token = tokenExpr.lessThanEqual;
                        firstPart = i - 1;
                        secondPart = i;
                        i--;
                    }
                    else if (str[i] == '>')
                        token = tokenExpr.moreThan;
                    else if (str[i] == '<')
                        token = tokenExpr.lessThan;
                    else if (str[i] == '.')
                        token = tokenExpr.concat;
                    else if (str[i] == '+')
                        token = tokenExpr.plus;
                    else if (str[i] == '-')
                        token = tokenExpr.minus;
                    else if (str[i] == '*')
                        token = tokenExpr.mult;
                    else if (str[i] == '/')
                        token = tokenExpr.div;
                    else if (str[i] == '^')
                        token = tokenExpr.pow;

                    if (str[i] == '(')
                        p++;
                    else if (str[i] == ')')
                        p--;
                    else if (p == 0 && ( token != tokenExpr.notfound ) && (bool)operateurs[(int)token])
                    {
                        this.operateur = token;
                        this.expra = new Parseur(str.Substring(0, firstPart));
                        string titi = str.Substring(0,firstPart);
                        this.exprb = new Parseur(str.Substring(secondPart + 1));
                        string toto = str.Substring(secondPart + 1);
                        break;
                    }
                }
                if (this.expra == null && cp0 == 1)
                {
                    if (this.isString(str.Substring(1, l - 2)))
                    {
                        this.val.sval = str.Substring(1, l - 2);
                        this.val.typVal = 'S';
                    }
                    else if (this.isNumeric(str.Substring(1, l - 2)))
                    {
                        this.val.fval = this.numval(str.Substring(1, l - 2));
                        this.val.typVal = 'N';
                    }
                    else
                    {
                        this.expra = new Parseur(str.Substring(1, l - 2));
                    }
                }
            }
        }
        public bool isNumeric(string str)
        {
            try
            {
                float val = float.Parse(str);
                return true;
            }
            catch
            {
                return false;
            }
        }
        public bool isString(string str)
        {
            int l = str.Length;
            if (l < 2)
                return false;
            if (str[0] != '"')
            {
                return false;
            }
            for (int i = 1; i < l; i++)
            {
                if (str[i] == '\\'){
                    i++;
                    continue;
                }
                if (str[i] == '"')
                {
                    if (i == l - 1)
                        return true;
                    else
                        return false;
                }
            }
            return false;
        }

        public float numval(string str)
        {
            try
            {
                float val = float.Parse(str);
                return val;
            }
            catch
            {
                return 0;
            }
        }
        public unionVal getval()
        {
            if (this.val.typVal != 'I')
                return this.val;
            else if (this.exprb == null)
            {
                if (this.expra == null)
                    throw new Exception("Erreur probablement dans l\'enchainement des operateurs...");
                else
                    return this.expra.getval();
            }
            unionVal reta = this.expra.getval();
            unionVal retb = this.exprb.getval();
            if (this.operateur == tokenExpr.equal
                || this.operateur == tokenExpr.diff
                || this.operateur == tokenExpr.moreThan
                || this.operateur == tokenExpr.lessThan
                || this.operateur == tokenExpr.moreThanEqual
                || this.operateur == tokenExpr.lessThanEqual
                )
            {
                if (reta.typVal == 'S' || retb.typVal == 'S')
                {
                    if (reta.typVal != 'S')
                    {
                        reta.typVal = 'S';
                        reta.sval = "\"" + reta.sval.ToString() + "\"";
                    }
                    if (retb.typVal != 'S')
                    {
                        retb.typVal = 'S';
                        retb.sval = "\"" + retb.sval.ToString() + "\"";
                    }
                }

            }
            if (this.operateur == tokenExpr.concat)
            {
                if (reta.typVal == 'N')
                {
                    reta.sval = "\"" + reta.fval.ToString() + "\"";
                    reta.typVal = 'S';
                }
                if (retb.typVal == 'N')
                {
                    retb.sval = "\"" + retb.fval.ToString() + "\"";
                    retb.typVal = 'S';
                }
            }
            bool isHMS = false;
/*
            if (this.operateur == tokenExpr.plus
                || this.operateur == tokenExpr.or
                || this.operateur == tokenExpr.and
                || this.operateur == tokenExpr.minus
                || this.operateur == tokenExpr.mult
                || this.operateur == tokenExpr.div
                || this.operateur == tokenExpr.pow
                )
*/
            {
                if (reta.typVal == 'S')
                {
                    if( LFSLapper.unitConv.isHMST( utils.unquote(reta.sval) ) ){
                        isHMS = true;
                        reta.fval = (float)LFSLapper.unitConv.HMSToLong(utils.unquote(reta.sval));
                        reta.typVal = 'S';
                    }
                    else{
                        reta.fval = this.numval(utils.unquote(reta.sval));
                        reta.typVal = 'N';
                    }
                }
                if (retb.typVal == 'S')
                {
                    if (LFSLapper.unitConv.isHMST(utils.unquote(retb.sval)))
                    {
                        isHMS = true;
                        retb.fval = (float)LFSLapper.unitConv.HMSToLong(utils.unquote(retb.sval));
                        retb.typVal = 'S';
                    }
                    else
                    {
                        retb.fval = this.numval(utils.unquote(retb.sval));
                        retb.typVal = 'N';
                    }
                }
            }
            switch (this.operateur)
            {
                case tokenExpr.and:
                    if (reta.fval != 0 && retb.fval != 0)
                        return new unionVal(1, "", 'N');
                    else
                        return new unionVal(0, "", 'N');
                case tokenExpr.or:
                    if (reta.fval != 0 || retb.fval != 0)
                        return new unionVal(1, "", 'N');
                    else
                        return new unionVal(0, "", 'N');
                case tokenExpr.equal:
                    if (reta.typVal == 'S')
                    {
                        if (reta.sval == retb.sval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval == retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                case tokenExpr.diff:
                    if (reta.typVal == 'S')
                    {
                        if (reta.sval != retb.sval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval != retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                case tokenExpr.moreThan:
                    if (reta.typVal == 'S')
                    {
                        if (string.Compare(reta.sval, retb.sval) > 0)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval > retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                case tokenExpr.moreThanEqual:
                    if (reta.typVal == 'S')
                    {
                        if (string.Compare(reta.sval, retb.sval) >= 0 )
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval >= retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                case tokenExpr.lessThan:
                    if (reta.typVal == 'S')
                    {
                        if (string.Compare(reta.sval, retb.sval) < 0)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval < retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                case tokenExpr.lessThanEqual:
                    if (reta.typVal == 'S')
                    {
                        if (string.Compare(reta.sval, retb.sval) <= 0)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }
                    else
                    {
                        if (reta.fval <= retb.fval)
                            return new unionVal(1, "", 'N');
                        else
                            return new unionVal(0, "", 'N');
                    }

                case tokenExpr.concat:
                    return new unionVal(0, "\"" + utils.unquote(reta.sval) + utils.unquote(retb.sval) + "\"", 'S');
                case tokenExpr.plus:
                    if( isHMS )
                        return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(reta.fval + retb.fval)) + "\"", 'S');
                    else
                        return new unionVal(reta.fval + retb.fval, "", 'N');
                case tokenExpr.minus:
                    if (isHMS)
                        return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(reta.fval - retb.fval)) + "\"", 'S');
                    else
                        return new unionVal(reta.fval - retb.fval, "", 'N');
                case tokenExpr.mult:
                    if (isHMS)
                        return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(reta.fval * retb.fval)) + "\"", 'S');
                    else
                        return new unionVal(reta.fval * retb.fval, "", 'N');
                case tokenExpr.div:
                    if (retb.fval == 0)
                        throw new Exception("Division par 0");
                    if (isHMS)
                        return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(reta.fval / retb.fval)) + "\"", 'S');
                    else
                        return new unionVal(reta.fval / retb.fval, "", 'N');
                case tokenExpr.pow:
                    if (retb.fval == 0)
                    {
                        return new unionVal(1, "", 'N');
                    }
                    else if (reta.fval == 0)
                    {
                        return new unionVal(0, "", 'N');
                    }
                    else if (retb.fval != Math.Ceiling(retb.fval) && reta.fval <= 0)
                    {
                        if ((1 / retb.fval) == Math.Ceiling(1 / retb.fval) && Math.Abs(1 / retb.fval) % 2 == 1)
                        {
                            if (isHMS)
                                return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(-Math.Pow(-reta.fval, retb.fval))) + "\"", 'S');
                            else
                                return new unionVal((float)(-Math.Pow(-reta.fval, retb.fval)),"",'N');
                        }
                        else
                        {
                            throw new Exception("On ne peut pas prendre un exposant non entier sur un nombre negatif");
                        }
                    }
                    else
                    {
                        if (isHMS)
                            return new unionVal(0, "\"" + LFSLapper.unitConv.LongToHMS((long)(Math.Pow(reta.fval, Math.Ceiling(retb.fval)))) + "\"", 'S');
                        else
                            return new unionVal((float)Math.Pow(reta.fval, Math.Ceiling(retb.fval)), "", 'N');
                    }
                default:
                    throw new Exception("operateur " + this.operateur + "non definit");
                    return new unionVal( 0,"",'N' );
            }
        }
        public string ToRPN()
        {
            if (this.val.typVal != 'I')
            {
                if (this.val.typVal == 'N')
                    return this.val.fval.ToString();
                else
                    return this.val.sval;
            }
            else if (this.exprb == null && this.expra != null)
            {
                return this.expra.ToRPN();
            }
            else if (this.expra == null && this.exprb != null)
            {
                if (this.operateur != tokenExpr.notfound)
                    return this.exprb.ToRPN() + " " + this.operateur;
                else
                    return this.exprb.ToRPN();
            }
            else if (this.expra != null && this.exprb != null)
            {
                return this.expra.ToRPN() + " " + this.exprb.ToRPN() + " " + this.operateur;
            }
            return "";
        }
    }
}
